/*:-----------------------------------------------------------------------------------
 * CounterExtend_ActorPicture_Attach.js
 * 
 * Copyright (C) 2021 NUUN
 * This software is released under the MIT License.
 * http://opensource.org/licenses/mit-license.php
 * -------------------------------------------------------------------------------------
 */ 
 /*:
 * @target MZ
 * @plugindesc 反撃拡張_立ち絵、顔グラ表示EX_アタッチメント
 * @author くろあめ
 * @base NUUN_Base
 * @orderAfter NUUN_ActorPicture
 * @version 0.9.0
 * 
 * @param BattleQuickeningSwitch
 * @text 戦闘加速スイッチ
 * @desc このスイッチがONの時、戦闘アニメの再生終了を待たずにダメージ表示を行い、戦闘を加速します。
 * @default 4
 * @type number
 *
 * @param BattleQuickeningKey
 * @text 戦闘加速キー
 * @desc このキーが押されている間、戦闘が加速します。「noFast」指定で、機能を無効化します。
 * @type select
 * @option shift
 * @value shift
 * @option control
 * @value control
 * @option pageup
 * @value pageup
 * @option pagedown
 * @value pagedown
 * @option tab
 * @value tab
 * @option noskip
 * @value noskip
 * @default shift
 *
 * @help
 * トリアコンタンさんの反撃拡張プラグインが起こした反撃に対して
 * NUUNさんの立ち絵、顔グラ表示EXを反応させ
 * アクターの立ち絵指定を切り替えます。
 * 
 * 切り替わる立ち絵は「反撃時」「魔法反射時」で指定したそれではなく
 * 反撃に使用したスキルを使うときの立ち絵になります。
 * 
 * また、オマケ機能として、指定した特定のスイッチがONの時、もしくは加速キーONのときに
 * 反撃発生時のアニメの再生終了まで待たずに、反撃実行を行います。
 * 
 * 
 * 
 * 【2025.02.09 機能追加】
 * 反撃拡張プラグインが起こした反撃に対して
 * スキル使い込み機構の使い込み値蓄積を反応させます。
 * 
 * 
 */

(function() {

    'use strict';
    const script = document.currentScript;
    const param = PluginManagerEx.createParameter(script);
    
    const _Game_Actor_initMembers_CounterExtend_ActorPicture_Attach = Game_Actor.prototype.initMembers;
    Game_Actor.prototype.initMembers = function() {
      _Game_Actor_initMembers_CounterExtend_ActorPicture_Attach.call(this);
      this.onInvokeCounter = false; // KURO仕様 今反撃中フラグ
    };
    
    Game_Actor.prototype.matchChangeGraphic = function(data) {
      const changeData = data.ChangeGraphicScenes;
      this._imgScenes = changeData;
      switch (changeData) {
        case 'default' :
          return true;
        case 'death' :
          return this.isDead();
        case 'command' :
          return this.isInputting();
        case 'dying' :
          return this.isDying();
        case 'damage' :
        return this.onImgId === 1;
        case 'recovery' :
          return this.onImgId === 2;
        case 'attack' :
          return (this.onImgId === 10 && this.isCondUseItemImg(data.Skill)) || (this.onInvokeCounter && this.isCondUseItemImg(data.Skill));
        case 'recoverySkill' :
          return this.onImgId === 11 && this.isCondUseItemImg(data.Skill);
        case 'item' :
          return this.onImgId === 12 && this.isCondUseItemImg(data.Item);
        case 'chant' :
          return this.isChanting();
        case 'victory' :
          return this.onImgId === 20;
        case 'state' :
          return this.isCondStateImg(data, data.stateId);
        case 'counter' :
          return this.onImgId === 30;
        case 'reflection' :
          return this.onImgId === 31;
        case 'counterEX' :
          //return this.onImgId === 32 && this.isCondUseItemImg(data.Id);
          return this.onImgId === 32 && this.onInvokeCounter;
        case 'guard' :
          return this.onImgId === 15;
      }
    };
    
    // コアスクリプト関数の再定義
    /*
    const _Game_Actor_performActionEnd_CounterExtend_ActorPicture_Attach = Game_Actor.prototype.performActionEnd;
    Game_Actor.prototype.performActionEnd = function() {
        _Game_Actor_performActionEnd_CounterExtend_ActorPicture_Attach.apply(this, arguments);
        this.invokeCounterEnd();  // KURO仕様 カウンター発動中フラグOFF
    };
    */
    // CounterExtend の関数再定義
    BattleManager.startCounterAction = function(subject, target, counterAction) {
    
        // KURO仕様 カウンター発動中フラグON
        subject.invokeCounterStart(counterAction);
        
        this._phase = "action";
        this._counterSubject = subject;
        this._subject = subject;
        this._action = counterAction;
        this._targets = counterAction.makeTargets();
        subject.cancelMotionRefresh();
        const counter = counterAction.getCounter();
        if (counter.PayCounterCost) {
            subject.useItem(counterAction.item());
        }
        else if(this._subject.isActor()){ // 2025.02.09 スキル使い込み機構の緩衝コード追加
            this._subject.setMasterySavevalues(counterAction.item());
        }
        this._action.applyGlobal();
        this._logWindow.displaySkillCounter(subject, counter);
        this._logWindow.startAction(subject, counterAction, this._targets);
    };

    // KURO仕様 反撃中フラグのON/OFF
    Game_BattlerBase.prototype.invokeCounterStart = function(action) {
    };
    Game_Actor.prototype.invokeCounterStart = function(action) {
      this.onInvokeCounter = true; 
      this.setAttackImgId(action);
      this.imgRefresh();
    };
    Game_BattlerBase.prototype.invokeCounterEnd = function() {
    };
    Game_Actor.prototype.invokeCounterEnd = function() {
      this.onInvokeCounter = false; 
      this.imgRefresh();
    };
    
    // KURO仕様 反撃中フラグのON/OFF パーティ内一括
    Game_Party.prototype.invokeCounterEndAll = function() {
      for (const actor of this.allMembers()) {
          actor.invokeCounterEnd(); 
      }
    };

    /**
     * Window_BattleLog
     * 反撃の演出とメッセージ表示
     */
    Window_BattleLog.prototype.displaySkillCounter = function(subject, counter) {
        if (counter.Message) {
            this.push("addText", counter.Message.format(subject.name()));
        }
        if (counter.Animation) {
            this.push('showAnimation', subject, [subject], counter.Animation);
            // 戦闘加速
            if(!$gameSwitches.value(param['BattleQuickeningSwitch']) && !Input.isPressed(param['BattleQuickeningKey'])) this.push('waitForAnimation');
        }
    };
})();
